<?php
require_once "header.php";
?>

<?php
if ($settings->efaturadurum == 1 and $settings->earsivdurum == 0) {
    ?>
    <div class="card shadow-sm mb-10">
        <div class="card-body">
            <form action="transferred-invoices.php" method="get" id="filtreForm">
                <div class="row">
                    <div class="col-lg-3">
                        <select class="form-select" data-control="select2" id="durum" name="status">
                            <option value="0" <?php if ($_GET['status'] == 0 or $_GET['status'] == '') echo "selected"; ?>>
                                Resmileştirme Bekleyenler
                            </option>
                            <option value="1" <?php if ($_GET['status'] == 1) echo "selected"; ?>>Resmileştirilenler
                            </option>
                            <option value="2" <?php if ($_GET['status'] == 2) echo "selected"; ?>>Tümü</option>
                        </select>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <?php
}
?>
<div class="card shadow-sm">
    <div class="card-header">
        <h3 class="card-title">Aktarılan Faturalar</h3>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="align-baseline border gs-5 table table-hover table-striped" id="aktarilanFaturalarDatatable">
                <thead>
                <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                    <th width="100" class="text-center">Fatura ID</th>
                    <th>Fatura Tarihi</th>
                    <th>Müşteri</th>
                    <th>Fatura Numarası</th>
                    <th>Fatura Tutarı</th>
                    <th>Ödeme Tarihi</th>
                    <th>Aktarma Tarihi</th>
                    <?php
                    if ($settings->efaturadurum == 1 and $settings->earsivdurum == 0) {
                        ?>
                        <th>İşlem</th>
                        <?php
                    }
                    ?>
                </tr>
                </thead>
                <tbody>
                <?php
                if ($transferredInvoices->num_rows > 0) {
                    while ($result = $transferredInvoices->fetch_object()) {
                        $invoice = $conn->query("SELECT * FROM tblinvoices WHERE id = $result->invoiceid")->fetch_object();
                        $client = $conn->query("SELECT * FROM tblclients WHERE id = $invoice->userid")->fetch_object();
                        $currency = $conn->query("SELECT * FROM tblcurrencies WHERE id = $client->currency")->fetch_object();
                        $total = number_format($invoice->total, 2);
                        if ($total == 0) {
                            $total = number_format($invoice->subtotal, 2);
                        }
                        ?>
                        <tr>
                            <td class="text-center">
                                <a class="btn btn-sm btn-white shadow-sm"
                                   href="../invoices.php?action=edit&id=<?php echo $invoice->id; ?>"
                                   target="_blank">
                                    <span><i class="fa fa-link"></i> <?php echo $invoice->id; ?></span>
                                </a>
                            </td>
                            <td><?php echo date('d-m-Y', strtotime($invoice->date)); ?></td>
                            <td>
                                <a class="btn btn-sm btn-white shadow-sm"
                                   href="../clientssummary.php?userid=<?php echo $client->id; ?>"
                                   target="_blank">
                                    <?php
                                    if ($client->companyname != '' and ($client->firstname != '' or $client->lastname)) {
                                        echo '<span class="me-2"><i class="fa fa-building"></i> ' . $client->companyname . '</span> <span><i class="fa fa-user"></i> ' . $client->firstname . ' ' . $client->lastname . '</span>';
                                    } elseif ($client->companyname != '') {
                                        echo '<span class="me-2"><i class="fa fa-building"></i> ' . $client->companyname;
                                    } elseif ($client->firstname != '' or $client->lastname) {
                                        echo '<span><i class="fa fa-user"></i> ' . $client->firstname . ' ' . $client->lastname . '</span>';
                                    }
                                    ?>
                                </a>
                            </td>
                            <td><img src="https://sistem.cari.com.tr/web/assets/kurumsal/asset/img/cari-logo.svg"
                                     height="20" style="margin: -3px 7px 0px 0px;"><?php echo $result->fatura_no; ?>
                            </td>
                            <td><?php echo $currency->prefix . ' ' . $total; ?> </td>
                            <td><?php echo date('d-m-Y', strtotime($invoice->datepaid)); ?></td>
                            <td><?php echo date('d-m-Y H:i:s', strtotime($result->date)); ?></td>
                            <?php
                            if ($settings->efaturadurum == 1 and $settings->earsivdurum == 0) {
                                if ($result->resmilestirme == 0) {
                                    ?>
                                    <td>
                                        <a href="formalization-cari.php?id=<?php echo $result->id; ?>"
                                           class="btn btn-sm btn-success p-3 cari_success_btn resmilestir">
                                            <i class="fa fa-check-circle fs-4 me-2"></i> Resmileştir
                                        </a>
                                    </td>
                                    <?php
                                } elseif ($result->resmilestirme == 1) {
                                    ?>
                                    <td>
                                        <div class="btn btn-sm btn-success p-3 cari_success_btn">
                                            <i class="fa fa-check-circle fs-4 me-2"></i> Resmileştirildi
                                        </div>
                                        <a href="<?php echo $result->pdf; ?>"
                                           class="btn btn-sm btn-success p-3 cari_success_btn" target="_blank">
                                            <i class="fa fa-file fs-4 me-2"></i> PDF
                                        </a>
                                    </td>
                                    <?php
                                }
                            }
                            ?>
                        </tr>
                        <?php
                    }
                }
                ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php
require_once "footer.php";
?>
<script type="text/javascript">
    <?php
    $errorMessage = $_SESSION['errorMessage'];
    if ($_GET['result'] == 'success') {
    ?>
    Project.notification('success', 'Fatura Resmileştirme Başarılı');
    <?php
    }
    elseif ($_GET['result'] == 'error') {
    ?>
    Project.notification('error', "<?php echo $errorMessage; ?>");
    <?php
    }
    ?>
    $("#aktarilanFaturalarDatatable").DataTable({
        "ordering": false,
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Turkish.json"
        },
        dom: 'ftp'
    });

    $('.resmilestir').click(function (e) {
        e.preventDefault();
        Swal.fire({
            title: "İşleme devam edilsin mi?",
            text: "Elektronik ortamda oluşturulan faturalar tekrar oluşturulamaz.!",
            icon: "question",
            confirmButtonText: "Evet",
            confirmButtonClass: "cari_success_btn",
            confirmButtonColor: "#50cd89",
            showCancelButton: true,
            cancelButtonColor: "#f1416c",
            cancelButtonText: "İptal",
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = e.currentTarget.href;
            }
        });
    });

    $('#durum').change(function () {
        $('#filtreForm').submit();
    });
</script>