<?php
require_once "dbconnect.php";
require_once "cariApi.php";
$cariApi = new cariApi();

function para_cevir($para, $decimals = 2)
{
    if ($para == 0) {
        return "0.00";
    }
    return str_replace(',', '', number_format(str_replace(',', '', $para), $decimals, '.', ','));
}

$ids = $_GET["ids"];

$settings = $conn->query("SELECT * FROM cari_settings")->fetch_object();
$invoices = $conn->query("SELECT * FROM tblinvoices WHERE id IN (" . $ids . ")");

$data = array();
while ($entity = $invoices->fetch_object()) {
    $invoice = $conn->query("SELECT * FROM tblinvoices WHERE id = $entity->id")->fetch_object();
    $client = $conn->query("SELECT * FROM tblclients WHERE id = $invoice->userid")->fetch_object();
    $currency = $conn->query("SELECT * FROM tblcurrencies WHERE id = $client->currency")->fetch_object();
    $invoiceItems = $conn->query("SELECT * FROM tblinvoiceitems WHERE invoiceid = $invoice->id");

    $paraBirimi = $currency->code;
    $kurTutari = para_cevir($currency->rate, 2);

    $ara_toplam_tutar = number_format($invoice->subtotal, 2, '.', '');
    $toplam_kdv_tutari = number_format($invoice->tax, 2, '.', '');
    $genel_toplam_tutar = number_format($invoice->total, 2, '.', '');

    // bakiye ile ödendi ise veya kdv 0 ise
    // Türkiye ise
    if ($invoice->credit > 0 or $invoice->tax == 0) {
        if ($client->country == 'TR') {
            $genel_toplam_tutar = $ara_toplam_tutar;
            $ara_toplam_tutar = number_format(($genel_toplam_tutar / (100 + $settings->kdv)) * 100, 2, '.', '');
            $toplam_kdv_tutari = number_format($genel_toplam_tutar - $ara_toplam_tutar, 2, '.', '');
        }
    }

    $urunlerData = array();

    while ($invoiceItem = $invoiceItems->fetch_object()) {
        $urun_genel_toplam_tutar = number_format($invoiceItem->amount, 2, '.', '');
        $urun_ara_toplam_tutar = number_format($invoiceItem->amount, 2, '.', '');

        // bakiye ile ödendi ise veya kdv 0 ise
        if ($invoice->credit > 0 or $invoice->tax == 0) {
            $urun_genel_toplam_tutar = number_format($invoiceItem->amount, 2, '.', '');
            $urun_ara_toplam_tutar = number_format(($urun_genel_toplam_tutar / (100 + para_cevir($invoice->taxrate, 0))) * 100, 2, '.', '');
        }

        $urunlerData[] = array(
            'urun_baslik' => $invoiceItem->description,
            'barkod' => '', // isteğe bağlı
            'kdvsiz_tutar' => $urun_ara_toplam_tutar,
            'kdv_yuzde' => para_cevir($invoice->taxrate, 0),
            'kdvli_tutar' => $urun_genel_toplam_tutar,
            'adet' => '1'
        );
    }

    $unvan = '';
    $adsoyad = '';

    $dataTcVergiNo = '';
    $dataVergiDairesi = '';

    if ($settings->tcNoVergiNoSecimi == 1) {
        $tcNoValues = '';
        $tcNoFieldName = $settings->tcNoFieldName;
        if ($tcNoFieldName != '') {
            $tcNoFieldNameID = $conn->query("SELECT * FROM tblcustomfields WHERE fieldname LIKE '%$tcNoFieldName%'")->fetch_object()->id;
            $tcNoValues = $conn->query("SELECT * FROM tblcustomfieldsvalues WHERE fieldid = $tcNoFieldNameID AND relid = $client->id")->fetch_object()->value;
        }

        $vergiNoValues = '';
        $vergiNoFieldName = $settings->vergiNoFieldName;
        if ($vergiNoFieldName != '') {
            $vergiNoFieldNameID = $conn->query("SELECT * FROM tblcustomfields WHERE fieldname LIKE '%$vergiNoFieldName%'")->fetch_object()->id;
            $vergiNoValues = $conn->query("SELECT * FROM tblcustomfieldsvalues WHERE fieldid = $vergiNoFieldNameID AND relid = $client->id")->fetch_object()->value;
        }

        $vergiDairesiValues = '';
        $vergiDairesiFieldName = $settings->vergiDairesiFieldName;
        if ($vergiDairesiFieldName != '') {
            $vergiDairesiFieldNameID = $conn->query("SELECT * FROM tblcustomfields WHERE fieldname LIKE '%$vergiDairesiFieldName%'")->fetch_object()->id;
            $vergiDairesiValues = $conn->query("SELECT * FROM tblcustomfieldsvalues WHERE fieldid = $vergiDairesiFieldNameID AND relid = $client->id")->fetch_object()->value;
        }
        $dataVergiDairesi = $vergiDairesiValues;

        if ($vergiNoValues != '') {
            $dataTcVergiNo = $vergiNoValues;
        } else {
            $dataTcVergiNo = $tcNoValues;
        }
    } else {
        $dataTcVergiNo = $client->tax_id;
    }

    if ($dataTcVergiNo != '') {
        if ($client->companyname != '') {
            $unvan = $client->companyname;
        } else {
            $adsoyad = $client->firstname . ' ' . $client->lastname;
        }
    }

    $data[] = array(
        'version' => 2,
        'firma_code' => $settings->mukellef_code, // Ayarlar -> İşletme Bilgileri sayfasındaki Firma Kodu
        'fatura' => array(
            'fatura_id' => 'WHMCS' . $invoice->id, // sipariş numarası, aynısını tekrar kaydetmemek için. Her kayıtta farklı gönderilmelidir
            'aciklama' => '',
            'tarih' => date('d-m-Y', strtotime($invoice->date)), // fatura tarihi
            'saat' => date('H:i:s'), // fatura saati
            'vade_tarihi' => date('d-m-Y', strtotime($invoice->duedate)), // vade tarihi
            'seri_no' => $settings->seri_no, // isteğe bağlı, örn : CAR
            'sira_no' => '', // isteğe bağlı, örn : 2022000000120
            'ara_toplam_tutar' => $ara_toplam_tutar,
            'toplam_kdv_tutari' => $toplam_kdv_tutari,
            'genel_toplam_tutar' => $genel_toplam_tutar,
            'para_birimi' => $paraBirimi,
            'kur_tutari' => $kurTutari
        ),
        'musteri' => array(
            'unvan' => $unvan, // firma unvan (unvan veya ad_soyad tan en az 1 tanesi olmalıdır)
            'ad_soyad' => $adsoyad, // firma ad soyad (unvan veya ad_soyad tan en az 1 tanesi olmalıdır)
            'tc_vergi_no' => $dataTcVergiNo,
            'vergi_dairesi' => $dataVergiDairesi,
            'telefon' => $client->phonenumber,
            'email' => $client->email,
            'adres' => $client->address1,
            'il_baslik' => $client->city,
            'ilce_baslik' => $client->state,
            'ulke_baslik' => $client->country,
        ),
        'urunler' => $urunlerData
    );
}

$responseFaturaAktar = $cariApi->faturaAktar($data);

if ($responseFaturaAktar->status == 'versionError') {
    $_SESSION['errorMessage'] = $responseFaturaAktar->message;
    header("Location: pending-invoices.php?result=error");
}

$successFaturalar = $responseFaturaAktar->successFaturalar;
if (count($successFaturalar) > 0) {
    $date = date('Y-m-d H:i:s');
    foreach ($successFaturalar as $successFatura) {
        $fatura_id = substr($successFatura->fatura_id, 5);
        $fatura_no = $successFatura->fatura_no;
        $conn->query("INSERT INTO cari_transferredinvoices (invoiceid, date, fatura_no, resmilestirme) VALUES ('$fatura_id', '$date', '$fatura_no', '0')");
    }
    $conn->close();
}

$errorFaturalar = $responseFaturaAktar->errorFaturalar;
$errorFaturalarMessage = '';
if (count($errorFaturalar) > 0) {
    foreach ($errorFaturalar as $errorFatura) {
        $errorFaturaMessage = '';
        if (isset($errorFatura->message)) {
            $errorFaturaMessage = $errorFatura->message;
        } else if (isset($errorFatura->errorMessage)) {
            $errorFaturaMessage = $errorFatura->errorMessage;
        }
        $errorFaturalarMessage .= '[ ' . substr($errorFatura->faturaApiId, 5) . ' ] ' . $errorFaturaMessage . '<br>';
    }
}

$_SESSION['errorMessage'] = $errorFaturalarMessage;

header("Location: pending-invoices.php?result=" . $responseFaturaAktar->status . "");
?>