<?php
require_once "header.php";
?>
<div class="card shadow-sm">
    <div class="card-header">
        <h3 class="card-title">Bekleyen Faturalar</h3>
    </div>
    <div class="card-body">
        <div class="d-flex mb-5">
            <div class="btn btn-sm btn-secondary p-4 tumunu_sec me-3">
                <i class="fa fa-check-square fs-4 me-1"></i> Tümünü Seç
            </div>
            <div class="btn btn-sm btn-success p-4 cariye_aktar cari_success_btn">
                <i class="fa fa-cloud-arrow-up fs-4 me-1"></i> Cariye Aktar
            </div>
        </div>
        <div class="table-responsive">
            <table class="align-baseline border gs-5 table table-hover table-striped" id="bekleyenFaturalarDatatable">
                <thead>
                <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                    <th width="25" class="text-center">#</th>
                    <th width="100" class="text-center">Fatura ID</th>
                    <th>Fatura Tarihi</th>
                    <th>Müşteri</th>
                    <th>Fatura Tutarı</th>
                    <th>Ödeme Tarihi</th>
                </tr>
                </thead>
                <tbody>
                <?php
                if ($pendingInvoices->num_rows > 0) {
                    while ($result = $pendingInvoices->fetch_object()) {
                        $client = $conn->query("SELECT * FROM tblclients WHERE id = $result->userid")->fetch_object();
                        $currency = $conn->query("SELECT * FROM tblcurrencies WHERE id = $client->currency")->fetch_object();
                        $total = number_format($result->total, 2);
                        if ($total == 0) {
                            $total = number_format($result->subtotal, 2);
                        }
                        ?>
                        <tr>
                            <td>
                                <input class="form-check-input cari-form-check-input cursor-pointer" type="checkbox"
                                       id="flexCheckDefault<?php echo $result->id; ?>"
                                       value="<?php echo $result->id; ?>"/>
                            </td>
                            <td class="text-center">
                                <a class="btn btn-sm btn-white shadow-sm"
                                   href="../invoices.php?action=edit&id=<?php echo $result->id; ?>"
                                   target="_blank">
                                    <span><i class="fa fa-link"></i> <?php echo $result->id; ?></span>
                                </a>
                            </td>
                            <td><?php echo date('d-m-Y', strtotime($result->date)); ?></td>
                            <td>
                                <a class="btn btn-sm btn-white shadow-sm"
                                   href="../clientssummary.php?userid=<?php echo $client->id; ?>"
                                   target="_blank">
                                    <?php
                                    if ($client->companyname != '' and ($client->firstname != '' or $client->lastname)) {
                                        echo '<span class="me-2"><i class="fa fa-building"></i> ' . $client->companyname . '</span> <span><i class="fa fa-user"></i> ' . $client->firstname . ' ' . $client->lastname . '</span>';
                                    } elseif ($client->companyname != '') {
                                        echo '<span class="me-2"><i class="fa fa-building"></i> ' . $client->companyname;
                                    } elseif ($client->firstname != '' or $client->lastname) {
                                        echo '<span><i class="fa fa-user"></i> ' . $client->firstname . ' ' . $client->lastname . '</span>';
                                    }
                                    ?>
                                </a>
                            </td>
                            <td><?php echo $currency->prefix . ' ' . $total; ?> </td>
                            <td><?php echo date('d-m-Y', strtotime($result->datepaid)); ?></td>
                        </tr>
                        <?php
                    }
                }
                ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php
require_once "footer.php";
?>
<script type="text/javascript">
    <?php
    $errorMessage = $_SESSION['errorMessage'];
    if ($_GET['result'] == 'success') {
    ?>
    Project.notification('success', 'Fatura Aktarım Başarılı');
    <?php
    }
    elseif ($_GET['result'] == 'error') {
    ?>
    Project.notification('error', "<?php echo $errorMessage; ?>");
    <?php
    }
    ?>

    $("#bekleyenFaturalarDatatable").DataTable({
        "ordering": false,
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Turkish.json"
        },
        dom: 'ftp'
    });

    $('.cariye_aktar').click(function (e) {
        $checked_sayi = $('.cari-form-check-input:checked').length;
        if ($checked_sayi > 0) {
            $secilenler = '';
            $('.cari-form-check-input:checked').each(function () {
                $secilenler += $(this).val() + ',';
            });
            $secilenler = $secilenler.slice(0, -1);
            Swal.fire({
                title: "İşleme devam edilsin mi?",
                text: "Seçilen Faturalar Cari'ye Aktarılacak!",
                icon: "question",
                confirmButtonText: "Evet",
                confirmButtonClass: "cari_success_btn",
                confirmButtonColor: "#50cd89",
                showCancelButton: true,
                cancelButtonColor: "#f1416c",
                cancelButtonText: "İptal",
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "transfer-cari.php?ids=" + $secilenler + "";
                }
            });
        } else {
            Swal.fire({
                title: "Lütfen Fatura Seçiniz !",
                icon: "error",
                confirmButtonText: "Tamam",
                confirmButtonClass: "cari_success_btn",
                confirmButtonColor: "#50cd89",
            });
        }
    });
    var tumunu_sec = 0;
    $('.tumunu_sec').click(function (e) {
        if (tumunu_sec == 0) {
            tumunu_sec = 1;
            $('.cari-form-check-input').prop('checked', true);
        } else {
            tumunu_sec = 0;
            $('.cari-form-check-input').prop('checked', false);
        }
    });
</script>