<?php
require_once "dbconnect.php";
require_once "cariApi.php";
$cariApi = new cariApi();

if ($conn->query("SHOW TABLES LIKE 'cari_settings'")->num_rows > 0) {
    if (isset($_SESSION['cariwhmcsloggedin']) && $_SESSION['cariwhmcsloggedin'] === true) {
        header("Location: index.php");
    }
} else {
    header("Location: install.php");
}

$errorMessage = '';
$settings = $conn->query("SELECT * FROM cari_settings")->fetch_object();
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $responseLogin = $cariApi->login($email, $password);
    if ($responseLogin->status == 'success') {
        if ($settings->mukellef_code == $responseLogin->mukellefCode) {
            $_SESSION['cariwhmcsloggedin'] = true;
            header("Location: index.php");
        } else {
            $errorMessage = 'Yetkisiz Erişim !';
        }
    } else {
        $errorMessage = $responseLogin->errorMessage;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <title>Cari - WHMCS</title>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="canonical" href="https://www.cari.com.tr"/>
    <link rel="shortcut icon" href="https://sistem.cari.com.tr/web/assets/images/auth/favicon.png"/>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>
    <link href="https://www.whmcs.cari.com.tr/assets/plugins/global/plugins.bundle.css" rel="stylesheet"
          type="text/css"/>
    <link href="https://www.whmcs.cari.com.tr/assets/css/style.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="https://www.whmcs.cari.com.tr/assets/plugins/custom/loading/loading.css" rel="stylesheet"
          type="text/css"/>
    <link href="https://www.whmcs.cari.com.tr/assets/css/project.css" rel="stylesheet" type="text/css"/>
</head>
<body id="kt_body" class="app-blank app-blank bgi-size-cover bgi-position-center bgi-no-repeat">
<div class="d-flex flex-column flex-root" id="kt_app_root">
    <style>
        body {
            background-image: url('https://www.whmcs.cari.com.tr/assets/media/auth/bg10-dark.jpeg');
        }
    </style>
    <div class="d-flex flex-column flex-center flex-column-fluid">
        <div class="d-flex flex-column flex-center text-center p-10">
            <div class="card card-flush w-md-650px py-5">
                <div class="card-body py-15 py-lg-20">
                    <form method="POST" class="form w-100" action="login.php" onsubmit="formSubmit();">
                        <div class="text-center mb-10">
                            <div class="align-items-center d-flex justify-content-around">
                                <img src="https://sistem.cari.com.tr/web/assets/images/auth/cari.svg" class="h-75px">
                                <img src="https://www.whmcs.cari.com.tr/assets/images/whmcs-logo.png" class="h-35px">
                            </div>
                            <div class="text-gray-600 fs-5 my-5">Cari - WHMCS | Hoşgeldiniz</div>
                        </div>
                        <div class="fv-row">
                            <input type="email" placeholder="E-Mail" name="email" autocomplete="off" id="email"
                                   class="form-control bg-transparent" required/>
                        </div>
                        <div class="fv-row mt-5">
                            <input type="password" placeholder="Şifre" name="password" autocomplete="off" id="password"
                                   class="form-control bg-transparent" required/>
                        </div>
                        <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-10">
                            <div></div>
                        </div>
                        <div class="d-grid mb-10">
                            <button type="submit" class="btn btn-success">
                                <span class="indicator-label">ONAYLA</span>
                            </button>
                        </div>
                        <div id="errorMessage">
                            <?php
                            if ($errorMessage != '') {
                                ?>
                                <div class="alert alert-danger d-flex align-items-center p-5">
                                    <i class="fa-solid fa-circle-exclamation text-danger me-2"></i>
                                    <div class="d-flex flex-column">
                                        <span><?php echo $errorMessage; ?></span>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>var hostUrl = "https://www.whmcs.cari.com.tr/assets/";</script>
<script src="https://www.whmcs.cari.com.tr/assets/plugins/global/plugins.bundle.js"></script>
<script src="https://www.whmcs.cari.com.tr/assets/js/scripts.bundle.js"></script>
<script src="https://www.whmcs.cari.com.tr/assets/plugins/custom/loading/loading.js"></script>
<script type="text/javascript">
    function formSubmit() {
        $.busyLoadFull("show", {
            spinner: "cari-loader",
            animation: "fade",
            background: "rgba(0, 0, 0, 0.5)"
        });
    }
</script>
</body>
</html>