<?php
require_once "dbconnect.php";
require_once "cariApi.php";
$cariApi = new cariApi();

if ($conn->query("SHOW TABLES LIKE 'cari_settings'")->num_rows > 0) {
    header("Location: index.php");
}

$errorMessage = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $mukellefCode = $_POST['mukellefCode'];
    $seriNo = $_POST['seriNo'];
    $tcNoVergiNoSecimi = $_POST['tcNoVergiNoSecimi'];
    $tcNoFieldName = $_POST['tcNoFieldName'];
    $vergiNoFieldName = $_POST['vergiNoFieldName'];
    $vergiDairesiFieldName = $_POST['vergiDairesiFieldName'];

    $responseMukellef = $cariApi->mukellef($mukellefCode);
    if ($responseMukellef->status == 'success') {
        $unvan = $responseMukellef->mukellef->unvan;
        $efaturadurum = $responseMukellef->mukellef->efaturaDurum;
        if ($efaturadurum == 'true') {
            $efaturadurum = 1;
        } else {
            $efaturadurum = 0;
        }
        $earsivdurum = $responseMukellef->mukellef->earsivDurum;
        if ($earsivdurum == 'true') {
            $earsivdurum = 1;
        } else {
            $earsivdurum = 0;
        }

        $conn->query("CREATE TABLE cari_settings ( id INT AUTO_INCREMENT PRIMARY KEY, mukellef_code VARCHAR(255) NOT NULL, unvan VARCHAR(255) NOT NULL, seri_no VARCHAR(255), kdv INT, tcNoVergiNoSecimi INT, tcNoFieldName VARCHAR(255), vergiNoFieldName VARCHAR(255), vergiDairesiFieldName VARCHAR(255), efaturadurum BOOL, earsivdurum BOOL)");
        if ($conn->query("SHOW TABLES LIKE 'cari_transferredinvoices'")->num_rows == 0) {
            $conn->query("CREATE TABLE cari_transferredinvoices ( id INT AUTO_INCREMENT PRIMARY KEY, invoiceid INT, date DATETIME, fatura_no VARCHAR(255), resmilestirme BOOL, pdf VARCHAR(255))");
        }
        $conn->query("INSERT INTO cari_settings (mukellef_code, unvan, seri_no, kdv, tcNoVergiNoSecimi, tcNoFieldName, vergiNoFieldName, vergiDairesiFieldName, efaturadurum, earsivdurum) VALUES ('$mukellefCode', '$unvan', '$seriNo', '20', '$tcNoVergiNoSecimi', '$tcNoFieldName', '$vergiNoFieldName', '$vergiDairesiFieldName', '$efaturadurum', '$earsivdurum')");
        $conn->close();

        $_SESSION['cariwhmcsloggedin'] = true;

        header("Location: index.php");
    } else {
        $errorMessage = $responseMukellef->errorMessage;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <title>Cari - WHMCS</title>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="canonical" href="https://www.cari.com.tr"/>
    <link rel="shortcut icon" href="https://sistem.cari.com.tr/web/assets/images/auth/favicon.png"/>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700"/>
    <link href="https://www.whmcs.cari.com.tr/assets/plugins/global/plugins.bundle.css" rel="stylesheet"
          type="text/css"/>
    <link href="https://www.whmcs.cari.com.tr/assets/css/style.bundle.css" rel="stylesheet" type="text/css"/>
    <link href="https://www.whmcs.cari.com.tr/assets/plugins/custom/loading/loading.css" rel="stylesheet"
          type="text/css"/>
    <link href="https://www.whmcs.cari.com.tr/assets/css/project.css" rel="stylesheet" type="text/css"/>
</head>
<body id="kt_body" class="app-blank app-blank bgi-size-cover bgi-position-center bgi-no-repeat">
<div class="d-flex flex-column flex-root" id="kt_app_root">
    <style>
        body {
            background-image: url('https://www.whmcs.cari.com.tr/assets/media/auth/bg10-dark.jpeg');
        }
    </style>
    <div class="d-flex flex-column flex-center flex-column-fluid">
        <div class="d-flex flex-column flex-center text-center p-10">
            <div class="card card-flush w-md-650px py-5">
                <div class="card-body py-15 py-lg-20">
                    <form method="POST" class="form w-100" action="install.php" onsubmit="return formSubmit();">
                        <div class="text-center mb-10">
                            <div class="align-items-center d-flex justify-content-around">
                                <img src="https://sistem.cari.com.tr/web/assets/images/auth/cari.svg" class="h-75px">
                                <img src="https://www.whmcs.cari.com.tr/assets/images/whmcs-logo.png" class="h-35px">
                            </div>
                            <div class="text-gray-600 fs-5 my-5">Cari - WHMCS Kurulumuna Hoşgeldiniz</div>
                        </div>
                        <div class="fv-row">
                            <input type="text" placeholder="Firma Kodu" name="mukellefCode" autocomplete="off"
                                   id="mukellefCode"
                                   class="form-control bg-transparent" required="required"/>
                        </div>
                        <div class="fv-row mt-5 d-none" id="seriNoBox">
                            <select class="form-select" data-control="select2" data-placeholder="Fatura Seri No"
                                    name="seriNo" id="seriNoSelect">
                                <option value=""></option>
                            </select>
                        </div>
                        <div class="fv-row mt-5 d-none" id="tcNoVergiNoSecimiBox">
                            <select class="form-select" data-control="select2"
                                    data-placeholder="T.C Kimlik Numarası / Vergi Numarası Seçimi"
                                    name="tcNoVergiNoSecimi" id="tcNoVergiNoSecimiSelect" required="required">
                                <option value=""></option>
                                <option value="1">Custom Fields</option>
                                <option value="2">Client tax_id</option>
                            </select>
                        </div>
                        <div class="fv-row mt-5 d-none" id="tcNoFieldNameBox">
                            <input type="text" placeholder="T.C Kimlik Numarası Field Name (Yoksa boş bırakın)"
                                   name="tcNoFieldName" autocomplete="off" id="tcNoFieldName"
                                   class="form-control bg-transparent"/>
                        </div>
                        <div class="fv-row mt-5 d-none" id="vergiNoFieldNameBox">
                            <input type="text" placeholder="Vergi Numarası Field Name (Yoksa boş bırakın)"
                                   name="vergiNoFieldName" autocomplete="off" id="vergiNoFieldName"
                                   class="form-control bg-transparent"/>
                        </div>
                        <div class="fv-row mt-5 d-none" id="vergiDairesiFieldNameBox">
                            <input type="text" placeholder="Vergi Dairesi Field Name (Yoksa boş bırakın)"
                                   name="vergiDairesiFieldName" autocomplete="off" id="vergiDairesiFieldName"
                                   class="form-control bg-transparent"/>
                        </div>
                        <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-10">
                            <div></div>
                        </div>
                        <div class="d-grid mb-10">
                            <button type="submit" class="btn btn-success">
                                <span class="indicator-label">ONAYLA</span>
                            </button>
                        </div>
                        <div id="errorMessage">
                            <?php
                            if ($errorMessage != '') {
                                ?>
                                <div class="alert alert-danger d-flex align-items-center p-5">
                                    <i class="fa-solid fa-circle-exclamation text-danger me-2"></i>
                                    <div class="d-flex flex-column">
                                        <span><?php echo $errorMessage; ?></span>
                                    </div>
                                </div>
                                <?php
                            }
                            ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>var hostUrl = "https://www.whmcs.cari.com.tr/assets/";</script>
<script src="https://www.whmcs.cari.com.tr/assets/plugins/global/plugins.bundle.js"></script>
<script src="https://www.whmcs.cari.com.tr/assets/js/scripts.bundle.js"></script>
<script src="https://www.whmcs.cari.com.tr/assets/plugins/custom/loading/loading.js"></script>
<script type="text/javascript">
    $(document).on({
        ajaxStart: function () {
            $.busyLoadFull("show", {
                spinner: "cari-loader",
                animation: "fade",
                background: "rgba(0, 0, 0, 0.5)"
            });
        },
        ajaxComplete: function () {
            $.busyLoadFull("hide");
        }
    });

    $('#mukellefCode').change(function () {
        var mukellefCode = $('#mukellefCode').val();
        seriNoGetir(mukellefCode);
    });

    $('#tcNoVergiNoSecimiSelect').change(function () {
        var tcNoVergiNoSecimi = $('#tcNoVergiNoSecimiSelect').val();
        if (tcNoVergiNoSecimi == '1') {
            $('#tcNoFieldNameBox').removeClass('d-none');
            $('#vergiNoFieldNameBox').removeClass('d-none');
            $('#vergiDairesiFieldNameBox').removeClass('d-none');
        } else {
            $('#tcNoFieldNameBox').addClass('d-none');
            $('#vergiNoFieldNameBox').addClass('d-none');
            $('#vergiDairesiFieldNameBox').addClass('d-none');
        }
    });

    function seriNoGetir(mukellefCode) {
        $('#errorMessage').html('');
        $('#seriNoSelect').html('').append("<option value=''></option>");
        $('#seriNoBox').addClass('d-none');
        $('#tcNoVergiNoSecimiSelect').val('').trigger('change');
        $('#tcNoVergiNoSecimiBox').addClass('d-none');
        $('#tcNoFieldNameBox').addClass('d-none');
        $('#vergiNoFieldNameBox').addClass('d-none');
        $('#vergiDairesiFieldNameBox').addClass('d-none');
        $.ajax({
            type: 'POST',
            url: 'fatura-seri-request.php',
            data: {"mukellefCode": mukellefCode},
            success: function (response) {
                if (response.status == 'success') {
                    $('#seriNoBox').removeClass('d-none');
                    $('#tcNoVergiNoSecimiBox').removeClass('d-none');
                    $('#seriNoSelect').attr('required', 'required');
                    $.each(response.entities, function (key, value) {
                        $('#seriNoSelect').append("<option value='" + value.baslik + "'>" + value.baslik + "</option>");
                    });
                } else {
                    $('#errorMessage').html('<div class="alert alert-danger d-flex align-items-center p-5"><i class="fa-solid fa-circle-exclamation text-danger me-2"></i> <div class="d-flex flex-column"><span>' + response.errorMessage + '</span> </div> </div>');
                }
            }
        });
    }

    function formSubmit() {
        var mukellefCode = $('#mukellefCode').val();
        var seriNoSelect = $('#seriNoSelect').val();

        if (mukellefCode != '' && seriNoSelect != '') {
            $.busyLoadFull("show", {
                spinner: "cari-loader",
                animation: "fade",
                background: "rgba(0, 0, 0, 0.5)"
            });
            return true;
        } else {
            return false;
        }
    }
</script>
</body>
</html>