<?php

class cariApi
{
    public function login($email, $password)
    {
        $url = 'https://www.sistem.cari.com.tr/api/cariapp/login';
        $data = array(
            'email' => $email,
            'password' => $password,
            'whmcsStatus' => 1
        );
        $jsonData = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        $headers = array(
            'Content-Type: application/json',
            'Authorization: $2b$10$t9a/sBMo9s5NZB31FQXVyurHFX4e13xaA.VBlNKy3AYRJreTrOBt.=='
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response);
    }

    public function mukellef($mukellefCode)
    {
        $url = 'https://www.sistem.cari.com.tr/api/cariapp/mukellef';
        $data = array(
            'mukellefCode' => $mukellefCode,
        );
        $jsonData = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        $headers = array(
            'Content-Type: application/json',
            'Authorization: $2b$10$t9a/sBMo9s5NZB31FQXVyurHFX4e13xaA.VBlNKy3AYRJreTrOBt.=='
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response);
    }

    public function faturaSeri($mukellefCode)
    {
        $url = 'https://www.sistem.cari.com.tr/api/cariapp/fatura-seri';
        $data = array(
            'mukellefCode' => $mukellefCode,
        );
        $jsonData = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        $headers = array(
            'Content-Type: application/json',
            'Authorization: $2b$10$t9a/sBMo9s5NZB31FQXVyurHFX4e13xaA.VBlNKy3AYRJreTrOBt.=='
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response);
    }

    public function faturaAktar($data)
    {
        $url = 'https://www.sistem.cari.com.tr/api/coklu-fatura-olustur';

        $jsonData = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        $headers = array(
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response);
    }

    public function faturaResmilestir($mukellefCode, $faturaNo)
    {
        $url = 'https://www.sistem.cari.com.tr/api/fatura-resmilestir';

        $data = array(
            'version' => 2,
            'firma_code' => $mukellefCode,
            'fatura_no' => $faturaNo
        );
        $jsonData = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        $headers = array(
            'Content-Type: application/json'
        );
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response);
    }
}